/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Words
extends JPanel {
    private static final Color BACKGROUND_COLOR = new Color(153, 204, 255);
    private static final Color PROGRESS_BAR_COLOR = new Color(0, 46, 187);
    private static final Color TEXT_FIELD_COLOR = new Color(150, 200, 240);
    private static final Color BUTTON_COLOR = new Color(108, 168, 225);
    private static final String MODE_NEW_QUESTION = "New Question";
    private static final String MODE_CHECK_ANSWER = "Check";
    private static final String MODE_NEW_GAME = "New Game";
    private static final String BAD_FORMAT = " Bad format";
    private static final String INSERT_WORDS = " Insert your words into the text area below!";
    private static final Dimension FIELD_SIZE = new Dimension(200, 25);
    private static final Dimension BUTTON_SIZE = new Dimension(130, 25);
    private static final Dimension PROGRESS_BAR_SIZE = new Dimension(537, 25);
    private static final Dimension MESSAGE_BAR_SIZE = new Dimension(400, 25);
    private static final Dimension VOC_AREA_SIZE = new Dimension(537, 100);
    private JCheckBox askForLanguage1CheckBox = null;
    private JTextField language1Word1Field = null;
    private JTextField language1Word2Field = null;
    private JTextField language1Word3Field = null;
    private JTextField language2Word1Field = null;
    private JTextField language2Word2Field = null;
    private JTextField language2Word3Field = null;
    private JRadioButton difficultyRadio1 = null;
    private JRadioButton difficultyRadio2 = null;
    private JRadioButton difficultyRadio3 = null;
    private JLabel messageLabel = null;
    private JButton okButton = null;
    private JButton loadButton = null;
    private Vector learnedWordsIndexes = null;
    private JProgressBar progressBar = null;
    private int index = -1;
    private KeyListener enterKeyListener;
    private JFrame f;
    private String title = "Words";
    private String language1 = "Language1";
    private String language2 = "Language2";
    private List language1words1List = new ArrayList();
    private List language1words2List = new ArrayList();
    private List language1words3List = new ArrayList();
    private List language2words1List = new ArrayList();
    private List language2words2List = new ArrayList();
    private List language2words3List = new ArrayList();
    private String fileName;
    private boolean wordsLoaded = false;
    private int parsedLineNr = 0;
    private JLabel lang1label = new JLabel();
    private JLabel lang2label = new JLabel();
    private JTextArea vocabularyFileArea = new JTextArea();
    private boolean errorInVocabularyFile = false;
    private int parsedLine = 0;

    public Words(boolean showInFrame) {
        if (showInFrame) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            this.f = new JFrame(this.title);
            this.f.setDefaultCloseOperation(3);
            this.f.setContentPane(this);
            this.f.setSize(580, 350);
            this.f.setResizable(false);
            this.f.setVisible(true);
        }
        this.init();
    }

    public void refresh() {
        this.repaint();
        this.revalidate();
    }

    private void init() {
        this.learnedWordsIndexes = new Vector();
        this.setLayout(new GridBagLayout());
        this.setBackground(BACKGROUND_COLOR);
        this.vocabularyFileArea.setFocusable(false);
        this.vocabularyFileArea.setBackground(TEXT_FIELD_COLOR);
        this.progressBar = new JProgressBar(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(PROGRESS_BAR_SIZE);
        this.progressBar.setForeground(PROGRESS_BAR_COLOR);
        this.progressBar.setBackground(TEXT_FIELD_COLOR);
        this.askForLanguage1CheckBox = new JCheckBox(this.language1);
        this.askForLanguage1CheckBox.setFocusable(false);
        this.askForLanguage1CheckBox.setSelected(false);
        this.askForLanguage1CheckBox.setEnabled(false);
        this.askForLanguage1CheckBox.setOpaque(false);
        this.language1Word1Field = new JTextField();
        this.language1Word1Field.setPreferredSize(FIELD_SIZE);
        this.language1Word2Field = new JTextField();
        this.language1Word2Field.setPreferredSize(FIELD_SIZE);
        this.language1Word3Field = new JTextField();
        this.language1Word3Field.setPreferredSize(FIELD_SIZE);
        this.language2Word1Field = new JTextField();
        this.language2Word1Field.setPreferredSize(FIELD_SIZE);
        this.language2Word2Field = new JTextField();
        this.language2Word2Field.setPreferredSize(FIELD_SIZE);
        this.language2Word3Field = new JTextField();
        this.language2Word3Field.setPreferredSize(FIELD_SIZE);
        this.language1Word1Field.setEditable(false);
        this.language1Word1Field.setFocusable(false);
        this.language1Word2Field.setEditable(false);
        this.language1Word2Field.setFocusable(false);
        this.language1Word3Field.setEditable(false);
        this.language1Word3Field.setFocusable(false);
        this.language2Word1Field.setEditable(false);
        this.language2Word1Field.setFocusable(false);
        this.language2Word2Field.setEditable(false);
        this.language2Word2Field.setFocusable(false);
        this.language2Word3Field.setEditable(false);
        this.language2Word3Field.setFocusable(false);
        this.language1Word1Field.setBackground(TEXT_FIELD_COLOR);
        this.language1Word2Field.setBackground(TEXT_FIELD_COLOR);
        this.language1Word3Field.setBackground(TEXT_FIELD_COLOR);
        this.language2Word1Field.setBackground(TEXT_FIELD_COLOR);
        this.language2Word2Field.setBackground(TEXT_FIELD_COLOR);
        this.language2Word3Field.setBackground(TEXT_FIELD_COLOR);
        this.language2Word1Field.requestFocus();
        JLabel difficultyLabel = new JLabel("Difficulty");
        difficultyLabel.setOpaque(false);
        this.difficultyRadio1 = new JRadioButton("1");
        this.difficultyRadio2 = new JRadioButton("2");
        this.difficultyRadio3 = new JRadioButton("3");
        this.difficultyRadio1.setPreferredSize(new Dimension(40, 15));
        this.difficultyRadio2.setPreferredSize(new Dimension(40, 15));
        this.difficultyRadio3.setPreferredSize(new Dimension(40, 15));
        this.difficultyRadio1.setOpaque(false);
        this.difficultyRadio2.setOpaque(false);
        this.difficultyRadio3.setOpaque(false);
        ButtonGroup difficultyGroup = new ButtonGroup();
        difficultyGroup.add(this.difficultyRadio1);
        difficultyGroup.add(this.difficultyRadio2);
        difficultyGroup.add(this.difficultyRadio3);
        JPanel difficultyPanel = new JPanel();
        difficultyPanel.setOpaque(false);
        difficultyPanel.add(this.difficultyRadio1);
        difficultyPanel.add(this.difficultyRadio2);
        difficultyPanel.add(this.difficultyRadio3);
        this.difficultyRadio1.setSelected(true);
        this.difficultyRadio2.setSelected(false);
        this.difficultyRadio3.setSelected(false);
        this.difficultyRadio1.setFocusable(false);
        this.difficultyRadio2.setFocusable(false);
        this.difficultyRadio3.setFocusable(false);
        this.difficultyRadio1.setBackground(TEXT_FIELD_COLOR);
        this.difficultyRadio2.setBackground(TEXT_FIELD_COLOR);
        this.difficultyRadio3.setBackground(TEXT_FIELD_COLOR);
        this.okButton = new JButton();
        this.okButton.setFocusable(false);
        this.okButton.setEnabled(false);
        this.okButton.setPreferredSize(BUTTON_SIZE);
        this.okButton.setBackground(BUTTON_COLOR);
        this.loadButton = new JButton("Load Words");
        this.loadButton.setFocusable(false);
        this.loadButton.setPreferredSize(BUTTON_SIZE);
        this.loadButton.setBackground(BUTTON_COLOR);
        this.messageLabel = new JLabel(" ...");
        this.messageLabel.setPreferredSize(MESSAGE_BAR_SIZE);
        this.messageLabel.setOpaque(false);
        JScrollPane scp = new JScrollPane(this.vocabularyFileArea);
        scp.setPreferredSize(VOC_AREA_SIZE);
        this.setLanguageLabels();
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.anchor = 18;
        gc.gridx = 0;
        gc.gridy = 0;
        this.add((Component)this.lang1label, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        this.add((Component)this.lang2label, gc);
        gc.gridx = 2;
        gc.gridy = 0;
        this.add((Component)this.askForLanguage1CheckBox, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        this.add((Component)this.language1Word1Field, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        this.add((Component)this.language1Word2Field, gc);
        gc.gridx = 0;
        gc.gridy = 3;
        this.add((Component)this.language1Word3Field, gc);
        gc.gridx = 1;
        gc.gridy = 1;
        this.add((Component)this.language2Word1Field, gc);
        gc.gridx = 1;
        gc.gridy = 2;
        this.add((Component)this.language2Word2Field, gc);
        gc.gridx = 1;
        gc.gridy = 3;
        this.add((Component)this.language2Word3Field, gc);
        gc.gridx = 2;
        gc.gridy = 1;
        this.add((Component)this.okButton, gc);
        gc.gridx = 2;
        gc.gridy = 2;
        gc.anchor = 15;
        this.add((Component)difficultyLabel, gc);
        gc.gridx = 2;
        gc.gridy = 3;
        gc.anchor = 18;
        this.add((Component)difficultyPanel, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.gridwidth = 3;
        this.add((Component)this.progressBar, gc);
        gc.gridx = 0;
        gc.gridy = 5;
        gc.gridwidth = 2;
        this.add((Component)this.messageLabel, gc);
        gc.gridx = 2;
        gc.gridy = 5;
        gc.gridwidth = 1;
        this.add((Component)this.loadButton, gc);
        gc.gridx = 0;
        gc.gridy = 6;
        gc.gridwidth = 3;
        this.add((Component)scp, gc);
        this.vocabularyFileArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Words.this.vocabularyFileArea.setFocusable(true);
                Words.this.vocabularyFileArea.requestFocus();
            }
        });
        this.vocabularyFileArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Words.this.vocabularyFileArea.setFocusable(false);
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Words.this.okButton.getText().equals(Words.MODE_NEW_GAME)) {
                    Words.this.newGame();
                } else if (Words.this.okButton.getText().equals(Words.MODE_NEW_QUESTION)) {
                    Words.this.newQuestion();
                } else if (Words.this.okButton.getText().equals(Words.MODE_CHECK_ANSWER)) {
                    Words.this.checkAnswer();
                }
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String vocText = Words.this.vocabularyFileArea.getText();
                StringReader r = new StringReader(vocText);
                Words.this.parseVocabylaryText(r);
                if (!Words.this.errorInVocabularyFile) {
                    vocText = Words.this.vocabularyFileArea.getText().trim();
                    Words.this.vocabularyFileArea.setText(vocText);
                    int i = 0;
                    while (i < 20) {
                        Words.this.vocabularyFileArea.append("\n");
                        ++i;
                    }
                    Words.this.newGame();
                }
            }
        });
        this.askForLanguage1CheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Words.this.newQuestion();
            }
        });
        this.enterKeyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (Words.this.okButton.getText().equals(Words.MODE_NEW_GAME)) {
                        Words.this.newGame();
                    } else if (Words.this.okButton.getText().equals(Words.MODE_NEW_QUESTION)) {
                        Words.this.newQuestion();
                    } else if (Words.this.okButton.getText().equals(Words.MODE_CHECK_ANSWER)) {
                        Words.this.checkAnswer();
                    }
                }
            }
        };
        this.language2Word1Field.addKeyListener(this.enterKeyListener);
        this.language2Word2Field.addKeyListener(this.enterKeyListener);
        this.language2Word3Field.addKeyListener(this.enterKeyListener);
        this.language1Word1Field.addKeyListener(this.enterKeyListener);
        this.language1Word2Field.addKeyListener(this.enterKeyListener);
        this.language1Word3Field.addKeyListener(this.enterKeyListener);
        this.okButton.addKeyListener(this.enterKeyListener);
        this.okButton.setText(MODE_NEW_GAME);
        this.progressBar.setValue(0);
        this.messageLabel.setText(INSERT_WORDS);
    }

    private void setLanguageLabels() {
        this.lang1label.setText(" " + this.language1);
        this.lang2label.setText(" " + this.language2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseVocabylaryText(Reader r) {
        block20: {
            block18: {
                block19: {
                    block17: {
                        this.errorInVocabularyFile = false;
                        this.language1words1List = new ArrayList<E>();
                        this.language1words2List = new ArrayList<E>();
                        this.language1words3List = new ArrayList<E>();
                        this.language2words1List = new ArrayList<E>();
                        this.language2words2List = new ArrayList<E>();
                        this.language2words3List = new ArrayList<E>();
                        lineNr = 0;
                        input = null;
                        try {
                            try {
                                vocText = this.vocabularyFileArea.getText().trim();
                                if (vocText.length() == 0) {
                                    this.showBadFormat(null);
                                    var9_7 = null;
                                    break block17;
                                }
                                input = new BufferedReader(r);
                                content = new String();
                                line = "";
                                this.parsedLine = 0;
                                while (true) {
                                    if ((line = input.readLine()) == null) {
                                        if (!this.language1words1List.isEmpty() && !this.language2words1List.isEmpty()) break block18;
                                        this.showBadFormat(null);
                                        break block19;
                                    }
                                    ++this.parsedLine;
                                    content = String.valueOf(content) + line + '\n';
                                    ++this.parsedLineNr;
                                    if (!(line.trim().length() <= 0 || line.trim().startsWith("#") || line.trim().startsWith("/") || line.trim().startsWith("@"))) {
                                        this.parseLine(line, lineNr);
                                        ++lineNr;
                                    }
                                    if (!line.trim().startsWith("@")) continue;
                                    langTokenizer = new StringTokenizer(line, ",");
                                    this.language1 = langTokenizer.nextToken().trim().substring(1);
                                    this.askForLanguage1CheckBox.setText(this.language1);
                                    if (langTokenizer.hasMoreTokens() && (lang2Token = langTokenizer.nextToken().trim()).startsWith("@")) {
                                        this.language2 = lang2Token.substring(1);
                                    }
                                    this.setLanguageLabels();
                                }
                            }
                            catch (FileNotFoundException ex) {
                                this.messageLabel.setText(ex.getMessage());
                                this.okButton.setEnabled(false);
                                break block18;
                            }
                            catch (IOException ex) {
                                this.messageLabel.setText(ex.getMessage());
                                this.okButton.setEnabled(false);
                                break block18;
                            }
                        }
                        catch (Throwable var10_19) {
                            var9_9 = null;
                            try {
                                if (input == null) throw var10_19;
                                input.close();
                                throw var10_19;
                            }
                            catch (IOException ex) {
                                this.messageLabel.setText(ex.getMessage());
                                this.okButton.setEnabled(false);
                            }
                            throw var10_19;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 449->460)] { 
lbl63:
                    // 1 sources

                    if (input == null) return;
                    input.close();
                    return;
lbl66:
                    // 1 sources

                    catch (IOException ex) {
                        this.messageLabel.setText(ex.getMessage());
                        this.okButton.setEnabled(false);
                    }
                    return;
                }
                var9_8 = null;
                ** try [egrp 2[TRYBLOCK] [6 : 449->460)] { 
lbl73:
                // 1 sources

                if (input == null) return;
                input.close();
                return;
lbl76:
                // 1 sources

                catch (IOException ex) {
                    this.messageLabel.setText(ex.getMessage());
                    this.okButton.setEnabled(false);
                }
                return;
            }
            var9_10 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 449->460)] { 
lbl83:
            // 1 sources

            if (input != null) {
                input.close();
            }
            break block20;
lbl86:
            // 1 sources

            catch (IOException ex) {
                this.messageLabel.setText(ex.getMessage());
                this.okButton.setEnabled(false);
            }
        }
        this.wordsLoaded = true;
        this.progressBar.setMaximum(this.language1words1List.size());
    }

    private void parseLine(String line, int wordNr) {
        StringTokenizer eqTokenizer = new StringTokenizer(line, "=");
        if (eqTokenizer.countTokens() == 2) {
            String lang1Words = eqTokenizer.nextToken();
            String lang2Words = eqTokenizer.nextToken();
            if (lang1Words.trim().length() > 0 && lang2Words.trim().length() > 0) {
                this.parseWords(lang1Words, wordNr, 1);
                this.parseWords(lang2Words, wordNr, 2);
            } else {
                this.showBadFormat(line);
            }
        } else {
            this.showBadFormat(line);
        }
    }

    private void showBadFormat(String line) {
        if (!this.errorInVocabularyFile) {
            if (line == null) {
                this.messageLabel.setText(INSERT_WORDS);
            } else {
                this.messageLabel.setText(" Bad format in line " + this.parsedLine + ": " + line);
            }
            this.okButton.setEnabled(false);
            this.askForLanguage1CheckBox.setEnabled(false);
            this.errorInVocabularyFile = true;
            this.language1Word1Field.setEditable(false);
            this.language1Word1Field.setFocusable(false);
            this.language1Word2Field.setEditable(false);
            this.language1Word2Field.setFocusable(false);
            this.language1Word3Field.setEditable(false);
            this.language1Word3Field.setFocusable(false);
            this.language2Word1Field.setEditable(false);
            this.language2Word1Field.setFocusable(false);
            this.language2Word2Field.setEditable(false);
            this.language2Word2Field.setFocusable(false);
            this.language2Word3Field.setEditable(false);
            this.language2Word3Field.setFocusable(false);
            this.language1Word1Field.setText("");
            this.language1Word2Field.setText("");
            this.language1Word3Field.setText("");
            this.language2Word1Field.setText("");
            this.language2Word2Field.setText("");
            this.language2Word3Field.setText("");
        }
    }

    private void parseWords(String words, int wordNr, int languageNr) {
        StringTokenizer eqTokenizer = new StringTokenizer(words, ",");
        int wordIndex = 0;
        while (eqTokenizer.hasMoreTokens()) {
            String word = eqTokenizer.nextToken().trim();
            if (languageNr == 1) {
                if (wordIndex == 0) {
                    this.language1words1List.add(word);
                    this.language1words2List.add("");
                    this.language1words3List.add("");
                } else if (wordIndex == 1) {
                    this.language1words2List.add(wordNr, word);
                } else if (wordIndex == 2) {
                    this.language1words3List.add(wordNr, word);
                }
            } else if (wordIndex == 0) {
                this.language2words1List.add(word);
                this.language2words2List.add("");
                this.language2words3List.add("");
            } else if (wordIndex == 1) {
                this.language2words2List.add(wordNr, word);
            } else if (wordIndex == 2) {
                this.language2words3List.add(wordNr, word);
            }
            ++wordIndex;
        }
    }

    private void newGame() {
        this.learnedWordsIndexes.removeAllElements();
        this.okButton.setText(MODE_NEW_QUESTION);
        this.okButton.setEnabled(true);
        this.progressBar.setString("");
        this.progressBar.setValue(0);
        this.askForLanguage1CheckBox.setEnabled(true);
        this.messageLabel.setText(" New Game");
        this.language2Word1Field.setText("");
        this.language2Word2Field.setText("");
        this.language2Word3Field.setText("");
        this.language1Word1Field.setText("");
        this.language1Word2Field.setText("");
        this.language1Word3Field.setText("");
        this.language2Word1Field.setToolTipText(null);
        this.language2Word2Field.setToolTipText(null);
        this.language2Word3Field.setToolTipText(null);
        this.language1Word1Field.setToolTipText(null);
        this.language1Word2Field.setToolTipText(null);
        this.language1Word3Field.setToolTipText(null);
        this.index = -1;
        this.newQuestion();
    }

    private void newQuestion() {
        if (this.askForLanguage1CheckBox.isSelected()) {
            this.language1Word1Field.setEditable(true);
            this.language1Word1Field.setFocusable(true);
            this.language1Word2Field.setEditable(true);
            this.language1Word2Field.setFocusable(true);
            this.language1Word3Field.setEditable(true);
            this.language1Word3Field.setFocusable(true);
            this.language2Word1Field.setEditable(false);
            this.language2Word1Field.setFocusable(false);
            this.language2Word2Field.setEditable(false);
            this.language2Word2Field.setFocusable(false);
            this.language2Word3Field.setEditable(false);
            this.language2Word3Field.setFocusable(false);
            this.language1Word1Field.requestFocus();
        } else {
            this.language1Word1Field.setEditable(false);
            this.language1Word1Field.setFocusable(false);
            this.language1Word2Field.setEditable(false);
            this.language1Word2Field.setFocusable(false);
            this.language1Word3Field.setEditable(false);
            this.language1Word3Field.setFocusable(false);
            this.language2Word1Field.setEditable(true);
            this.language2Word1Field.setFocusable(true);
            this.language2Word2Field.setEditable(true);
            this.language2Word2Field.setFocusable(true);
            this.language2Word3Field.setEditable(true);
            this.language2Word3Field.setFocusable(true);
            this.language2Word1Field.requestFocus();
        }
        if (this.language1words1List.size() > this.learnedWordsIndexes.size()) {
            this.index = -1;
            Vector<Integer> unlearedVerbsIndexes = new Vector<Integer>();
            int i = 0;
            while (i < this.language1words1List.size()) {
                if (!this.learnedWordsIndexes.contains(new Integer(i))) {
                    unlearedVerbsIndexes.add(new Integer(i));
                }
                ++i;
            }
            Random r = new Random();
            int i2 = r.nextInt(unlearedVerbsIndexes.size());
            this.index = (Integer)unlearedVerbsIndexes.get(i2);
            if (this.askForLanguage1CheckBox.isSelected()) {
                this.language1Word1Field.setText("");
                this.language1Word2Field.setText("");
                this.language1Word3Field.setText("");
                this.language1Word1Field.setToolTipText(null);
                this.language1Word2Field.setToolTipText(null);
                this.language1Word3Field.setToolTipText(null);
                this.language2Word1Field.setText(this.language2words1List.get(this.index).toString());
                this.language2Word2Field.setText(this.language2words2List.get(this.index).toString());
                this.language2Word3Field.setText(this.language2words3List.get(this.index).toString());
                this.language2Word1Field.setToolTipText(this.language2words1List.get(this.index).toString());
                this.language2Word2Field.setToolTipText(this.language2words2List.get(this.index).toString());
                this.language2Word3Field.setToolTipText(this.language2words3List.get(this.index).toString());
                this.language1Word1Field.requestFocus();
            } else {
                this.language1Word1Field.setText(this.language1words1List.get(this.index).toString());
                this.language1Word2Field.setText(this.language1words2List.get(this.index).toString());
                this.language1Word3Field.setText(this.language1words3List.get(this.index).toString());
                this.language1Word1Field.setToolTipText(this.language1words1List.get(this.index).toString());
                this.language1Word2Field.setToolTipText(this.language1words2List.get(this.index).toString());
                this.language1Word3Field.setToolTipText(this.language1words3List.get(this.index).toString());
                this.language2Word1Field.setText("");
                this.language2Word2Field.setText("");
                this.language2Word3Field.setText("");
                this.language2Word1Field.setToolTipText(null);
                this.language2Word2Field.setToolTipText(null);
                this.language2Word3Field.setToolTipText(null);
                this.language2Word1Field.requestFocus();
            }
            this.okButton.setText(MODE_CHECK_ANSWER);
        } else {
            this.language1Word1Field.setText("");
            this.language1Word2Field.setText("");
            this.language1Word3Field.setText("");
            this.language2Word1Field.setText("");
            this.language2Word2Field.setText("");
            this.language2Word3Field.setText("");
            this.okButton.setText(MODE_NEW_GAME);
        }
    }

    private boolean checkAnswer() {
        String correctAnswer;
        boolean answerIsCorrect = false;
        if (this.askForLanguage1CheckBox.isSelected()) {
            String l1w1 = this.language1words1List.get(this.index).toString().trim();
            String l1w2 = this.language1words2List.get(this.index).toString().trim();
            String l1w3 = this.language1words3List.get(this.index).toString().trim();
            String l2w1 = this.language2Word1Field.getText().trim();
            String l2w2 = this.language2Word2Field.getText().trim();
            String l2w3 = this.language2Word3Field.getText().trim();
            correctAnswer = l1w1;
            if (l1w2 != null && l1w2.length() > 0) {
                correctAnswer = String.valueOf(correctAnswer) + ", " + l1w2;
            }
            if (l1w3 != null && l1w3.length() > 0) {
                correctAnswer = String.valueOf(correctAnswer) + ", " + l1w3;
            }
        } else {
            String l1w1 = this.language1Word1Field.getText().trim();
            String l1w2 = this.language1Word2Field.getText().trim();
            String l1w3 = this.language1Word3Field.getText().trim();
            String l2w1 = this.language2words1List.get(this.index).toString().trim();
            String l2w2 = this.language2words2List.get(this.index).toString().trim();
            String l2w3 = this.language2words3List.get(this.index).toString().trim();
            correctAnswer = l2w1;
            if (l2w2 != null && l2w2.length() > 0) {
                correctAnswer = String.valueOf(correctAnswer) + ", " + l2w2;
            }
            if (l2w3 != null && l2w3.length() > 0) {
                correctAnswer = String.valueOf(correctAnswer) + ", " + l2w3;
            }
        }
        int matches = 0;
        int possibleCorrectAnswers = 0;
        if (this.askForLanguage1CheckBox.isSelected()) {
            if (this.language1words1List.get(this.index).toString().trim().length() > 0) {
                ++possibleCorrectAnswers;
            }
            if (this.language1words2List.get(this.index).toString().trim().length() > 0) {
                ++possibleCorrectAnswers;
            }
            if (this.language1words3List.get(this.index).toString().trim().length() > 0) {
                ++possibleCorrectAnswers;
            }
            if (!this.isFieldEmpty(this.language1Word1Field) && this.checkEquals(this.language1Word1Field.getText(), this.language1words1List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language1Word1Field) && this.checkEquals(this.language1Word1Field.getText(), this.language1words2List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language1Word1Field) && this.checkEquals(this.language1Word1Field.getText(), this.language1words3List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language1Word2Field) && this.checkEquals(this.language1Word2Field.getText(), this.language1words1List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language1Word2Field) && this.checkEquals(this.language1Word2Field.getText(), this.language1words2List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language1Word2Field) && this.checkEquals(this.language1Word2Field.getText(), this.language1words3List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language1Word3Field) && this.checkEquals(this.language1Word3Field.getText(), this.language1words1List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language1Word3Field) && this.checkEquals(this.language1Word3Field.getText(), this.language1words2List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language1Word3Field) && this.checkEquals(this.language1Word3Field.getText(), this.language1words3List.get(this.index).toString())) {
                ++matches;
            }
        } else {
            if (this.language2words1List.get(this.index).toString().trim().length() > 0) {
                ++possibleCorrectAnswers;
            }
            if (this.language2words2List.get(this.index).toString().trim().length() > 0) {
                ++possibleCorrectAnswers;
            }
            if (this.language2words3List.get(this.index).toString().trim().length() > 0) {
                ++possibleCorrectAnswers;
            }
            if (!this.isFieldEmpty(this.language2Word1Field) && this.checkEquals(this.language2Word1Field.getText(), this.language2words1List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language2Word1Field) && this.checkEquals(this.language2Word1Field.getText(), this.language2words2List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language2Word1Field) && this.checkEquals(this.language2Word1Field.getText(), this.language2words3List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language2Word2Field) && this.checkEquals(this.language2Word2Field.getText(), this.language2words1List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language2Word2Field) && this.checkEquals(this.language2Word2Field.getText(), this.language2words2List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language2Word2Field) && this.checkEquals(this.language2Word2Field.getText(), this.language2words3List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language2Word3Field) && this.checkEquals(this.language2Word3Field.getText(), this.language2words1List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language2Word3Field) && this.checkEquals(this.language2Word3Field.getText(), this.language2words2List.get(this.index).toString())) {
                ++matches;
            }
            if (!this.isFieldEmpty(this.language2Word3Field) && this.checkEquals(this.language2Word3Field.getText(), this.language2words3List.get(this.index).toString())) {
                ++matches;
            }
        }
        if (this.difficultyRadio1.isSelected() && matches > 0 || this.difficultyRadio2.isSelected() && (matches > 1 || possibleCorrectAnswers == matches) || this.difficultyRadio3.isSelected() && (matches > 2 || possibleCorrectAnswers == matches)) {
            this.learnedWordsIndexes.add(new Integer(this.index));
            answerIsCorrect = true;
            this.messageLabel.setText(" Correct (" + correctAnswer + ")");
        } else {
            this.messageLabel.setText(" Incorrect! The correct answer is: " + correctAnswer);
        }
        this.okButton.setText(MODE_NEW_QUESTION);
        this.progressBar.setValue(this.learnedWordsIndexes.size());
        this.progressBar.setToolTipText(String.valueOf(new Integer(this.learnedWordsIndexes.size()).toString()) + " out of " + this.language1words1List.size());
        this.progressBar.setString("Learned words: " + new Integer(this.learnedWordsIndexes.size()).toString());
        if (this.language1words1List.size() == this.learnedWordsIndexes.size()) {
            this.messageLabel.setText(" Congratulations!");
            this.okButton.setText(MODE_NEW_GAME);
        }
        return answerIsCorrect;
    }

    private boolean isFieldEmpty(JTextField tf) {
        boolean fieldIsEmpty = true;
        if (tf.getText().trim().length() > 0) {
            fieldIsEmpty = false;
        }
        return fieldIsEmpty;
    }

    private boolean checkEquals(String s1, String s2) {
        boolean equals = false;
        if (this.removeSpecialVowelsAndSigns(s1).equalsIgnoreCase(this.removeSpecialVowelsAndSigns(s2))) {
            equals = true;
        }
        return equals;
    }

    private String removeSpecialVowelsAndSigns(String word) {
        String modifiedWord = word.toLowerCase();
        modifiedWord = modifiedWord.replace('\u00e1', 'a');
        modifiedWord = modifiedWord.replace('\u00e9', 'e');
        modifiedWord = modifiedWord.replace('\u00f3', 'o');
        modifiedWord = modifiedWord.replace('\u00f6', 'o');
        modifiedWord = modifiedWord.replace('\u0151', 'o');
        modifiedWord = modifiedWord.replace('\u00fa', 'u');
        modifiedWord = modifiedWord.replace('\u00fc', 'u');
        modifiedWord = modifiedWord.replace('\u0171', 'u');
        modifiedWord = modifiedWord.replace('\u00ed', 'i');
        modifiedWord = modifiedWord.replace('?', ' ');
        modifiedWord = modifiedWord.replace('!', ' ');
        modifiedWord = modifiedWord.replace('.', ' ');
        return modifiedWord.trim();
    }

    public static void main(String[] args) {
        new Words(true);
    }
}

